<?php

require ( "config.php" );

function action_log( $action, $member_id, $token, $exp_date = null )
{
    global $mysql_host, $mysql_username, $mysql_password, $mysql_db;

    $mysql = new mysqli( $mysql_host, $mysql_username, $mysql_password, $mysql_db );

    $action = $mysql->real_escape_string( $action );
    $member_id = $mysql->real_escape_string( $member_id );
    $token = $mysql->real_escape_string( $token );
    if ( $exp_date != null )
        $exp_date = $mysql->real_escape_string( $exp_date );

    switch ( $action )
    {

        case "new_line":
            if ( isset( $exp_date ) )
            {
                $exp_date = ( $exp_date == "without" ) ? "without" : $exp_date - time();

                $mysql->query( "INSERT INTO `activity` (`action`,`member_id`,`token`,`date`,`notes`) VALUES ('new_line','" .
                    $member_id . "','" . $token . "','" . time() . "','" . $exp_date . "')" );
            }
            break;

        case "edit_line":
            if ( isset( $exp_date ) )
            {

                $exp_date_db = $mysql->query( "SELECT `expire_date` FROM `lines` WHERE `line_token` = '" .
                    $token . "'" );

                $exp_date_db = $exp_date_db->fetch_row();

                if ( $exp_date_db[0] != $exp_date )
                {
                    $diff = ( $exp_date == "without" ) ? "without" : $exp_date - time();
                    $diff = ( $diff <= 0 ) ? 0 : $diff;

                    $mysql->query( "INSERT INTO `activity` (`action`,`member_id`,`token`,`date`,`notes`) VALUES ('edit_line','" .
                        $member_id . "','" . $token . "','" . time() . "','" . $diff . "')" );
                }
            }
            break;

        case "delete_line":

            $mysql->query( "INSERT INTO `activity` (`action`,`member_id`,`token`,`date`) VALUES ('delete_line','" .
                $member_id . "','" . $token . "','" . time() . "')" );
            break;

        case "block_line":

            $mysql->query( "INSERT INTO `activity` (`action`,`member_id`,`token`,`date`) VALUES ('block_line','" .
                $member_id . "','" . $token . "','" . time() . "')" );
            break;

        case "unblock_line":

            $mysql->query( "INSERT INTO `activity` (`action`,`member_id`,`token`,`date`) VALUES ('new_line','" .
                $member_id . "','" . $token . "','" . time() . "')" );
            break;

    }

    $mysql->close();
}

function token_type($token)
{
    global $mysql_host, $mysql_username, $mysql_password, $mysql_db;

    $mysql = new mysqli( $mysql_host, $mysql_username, $mysql_password, $mysql_db );
    
    $check = $mysql->query("SELECT `line_type` FROM `lines` WHERE `line_token` = '".$token."'");
    
    $token_type = $check->fetch_row();
    
    $token_type = ($token_type[0] == "official") ? "official" : "trial";
    
    return $token_type;
    
    $mysql->close();
}

function token_exists( $token )
{
    global $mysql_host, $mysql_username, $mysql_password, $mysql_db;

    $mysql = new mysqli( $mysql_host, $mysql_username, $mysql_password, $mysql_db );

    $query = $mysql->query( "SELECT 1 FROM `lines` WHERE `token` = '" . $token . "'" );

    if ( $query->num_rows > 0 )
    {
        return true;
    }
    return false;
    $mysql->close();
}

function gen_rand( $user )
{
    if ( isset( $user ) )
        $first = substr( $user, 0, 2 );
    $rand = rand( 5, 13 );
    $alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789";
    $pass = array();
    $alphaLength = strlen( $alphabet ) - 1;
    for ( $i = 0; $i < $rand; $i++ )
    {
        $n = rand( 0, $alphaLength );
        $pass[] = $alphabet[$n];
    }
    $pass = implode( $pass );
    if ( isset( $user ) )
        $pass = $first . $pass;

    return $pass;

}


function secondsToTime($inputSeconds) {

    $secondsInAMinute = 60;
    $secondsInAnHour  = 60 * $secondsInAMinute;
    $secondsInADay    = 24 * $secondsInAnHour;

    // extract days
    $days = floor($inputSeconds / $secondsInADay);

    // extract hours
    $hourSeconds = $inputSeconds % $secondsInADay;
    $hours = floor($hourSeconds / $secondsInAnHour);

    // extract minutes
    $minuteSeconds = $hourSeconds % $secondsInAnHour;
    $minutes = floor($minuteSeconds / $secondsInAMinute);

    // extract the remaining seconds
    $remainingSeconds = $minuteSeconds % $secondsInAMinute;
    $seconds = ceil($remainingSeconds);

    // return the final array
    $obj = array(
        'd' => (int) $days,
        'h' => (int) $hours,
        'm' => (int) $minutes,
        's' => (int) $seconds,
    );

$obj = array_filter($obj);
$output = "";
foreach($obj as $key=>$value){    
        $output .= $value.$key; 
}
  $output = (empty($output)) ? "-":$output;
//$output = $obj['d'] . "d" . $obj['h'] . "h" . $obj['m'] . "m" . $obj['s'] . "s";
return $output;
}

function secondsToTime2( $inputSeconds )
{

    $inputSeconds = round( $inputSeconds );

    $unith = 3600;
    $unitm = 60;
    $unitd = 86400;
    
    $dd = intval($inputSeconds / $unitd);
    $dd_remaining = ($input_Seconds - ($dd * 86400));
    
    $hh = intval( $dd_remaining / $unith );
    $ss_remaining = ( $dd_remaining - ( $hh * 3600 ) );

    $mm = intval( $ss_remaining / $unitm );
    $ss = ( $ss_remaining - ( $mm * 60 ) );

    $output = $dd . "d" . $hh . "h" . $mm . "m" . $ss . "s";
    return $output;
}

function ago( $time, $milliseconds = false )
{
    if ( $milliseconds != false )
    {
        $timediff = $time / 1000;
    } else
        $timediff = time() - $time;

    $days = intval( $timediff / 86400 );
    $remain = $timediff % 86400;
    $hours = intval( $remain / 3600 );
    $remain = $remain % 3600;
    $mins = intval( $remain / 60 );
    $secs = $remain % 60;

    if ( $secs >= 0 )
        $timestring = "0m" . $secs . "s";
    if ( $mins > 0 )
        $timestring = $mins . "m" . $secs . "s";
    if ( $hours > 0 )
        $timestring = $hours . "h" . $mins . "m";
    if ( $days > 0 )
        $timestring = $days . "d" . $hours . "u";

    return $timestring;
}

function GetUserStaff( $token, $online_users )
{

    if ( array_key_exists( $token, $online_users ) )
    {
        return $online_users[$token];
    }

    return false;
}

function GetOnlineUsers()
{
    global $flus_username, $flus_password, $flus_host;

    $username = $flus_username;
    $password = $flus_password;
    if ( !empty( $username ) && !empty( $password ) )
    {
        $auth = base64_encode( $username . ":" . $password );
        $url = $flus_host . '/flussonic/api/sessions';
        $opts = array( 
        'http' => array( 'method' => "GET",
        'timeout' => 1200,
         'header' =>"Authorization: Basic $auth" ) );
        $ctx = stream_context_create( $opts );
        $result = file_get_contents( $url, false, $ctx );
        $array = json_decode( $result, true );

        $users = array();

        if ( !empty( $array['sessions'] ) )
        {
            foreach ( $array['sessions'] as $session )
            {
                if ( !array_key_exists( $session['token'], $users ) )
                    $users[$session['token']] = array();

                $users[$session['token']][] = $session;
            }
        }
    } else
        $users = "";

    return $users;
}

?>