<?php

class CreateJSON {

    function json_encode_cron_job($ordner, $file, $inhalt) {

        $job = [];

        // label
        $job['label'] = $inhalt['label'];

        // tpass
        $job['tpass'] = $inhalt['tpass'];

        // tip
        $job['tip'] = $inhalt['tip'];

        // tport
        $job['tport'] = $inhalt['tport'];

        // tfolder
        $job['tfolder'] = $inhalt['tfolder'];

        // bandwich
        $job['bandwich'] = $inhalt['bandwich'];

        // ownfolder
        $job['ownfolder'] = $inhalt['ownfolder'];

        $someArray = json_encode($job, JSON_UNESCAPED_UNICODE);

        $fp = fopen($ordner . '/' . $file . '.json', 'w');
        fwrite($fp, $someArray);
        fclose($fp);

        return $someArray;

    }

    function json_decode_cron_job($ordner, $file) {

        $jsonfile = file_get_contents($ordner . $file);

        $ausgabe = [];

        $someArray = json_decode($jsonfile);

        // label
        $ausgabe['label'] = $someArray->label;

        // bandwich
        if (empty($someArray->bandwich)) {
            $ausgabe['bandwich'] = 50000;
        } else {
            $ausgabe['bandwich'] = $someArray->bandwich;
        }

        // tip
        $ausgabe['tip'] = $someArray->tip;

        // tfolder
        $ausgabe['tfolder'] = $someArray->tfolder;

        // ownfolder
        $ausgabe['ownfolder'] = $someArray->ownfolder;

        // tpass
        $ausgabe['tpass'] = $someArray->tpass;

        // tport
        if (empty($someArray->tport)) {
            $ausgabe['tport'] = 22;
        } else {
            $ausgabe['tport'] = $someArray->tport;
        }


        return $ausgabe;

    }

    function json_encode_epg($ordner, $file, $inhalt, $language) {

        $epg = [];

        // EPG Language
        $epg['epglanguage'] = $language;

        // VodName
        $epg['VodName'] = $inhalt['-VodName'];

        // ID
        $epg['ID'] = $inhalt['-ID'];

        // Title
        $epg['Title'] = $inhalt['-Title'];

        // OriginalTitle
        $epg['OriginalTitle'] = $inhalt['-OriginalTitle'];

        // Plot
        $epg['Plot'] = $inhalt['-Plot'];

        // Gerne
        $epg['Gerne'] = $inhalt['-Gerne'];

        // Director
        $epg['Director'] = $inhalt['-Director'];

        // Runtime
        $epg['runtime'] = 'RuntimeInMinutes';

        // Cast
        $epg['Cast'] = $inhalt['-Cast'];

        // Release
        $epg['Release'] = $inhalt['-Release'];

        // Vote
        $epg['Vote'] = $inhalt['-Vote'];

        // Image
        $epg['Image'] = $inhalt['-Image'];

        // Path
        //$epg['Path'] = $inhalt['-PathName'];

        $someArray = json_encode($epg, JSON_UNESCAPED_UNICODE);

        //file_put_contents('myfile.json', $someArray);

        $fp = fopen($ordner . '/' . $file . '.json', 'w');
        fwrite($fp, $someArray);
        fclose($fp);

        return $someArray;

    }

    function json_decode_epg($ordner, $file) {

        $jsonfile = file_get_contents($ordner . '/' . $file . '.json');

        $ausgabe = [];

        $someArray = json_decode($jsonfile);

        // epglanguage
        $ausgabe['epglanguage'] = $someArray->epglanguage;

        // VodName
        $ausgabe['VodName'] = str_replace('&', 'AND', $someArray->VodName);

        // ID
        $ausgabe['id'] = $someArray->ID;

        // runtime
        $ausgabe['runtime'] = $someArray->runtime;

        // Title
        $ausgabe['Title'] = $someArray->Title;

        // vote_average
        $ausgabe['Vote'] = $someArray->Vote;

        // Original Title
        $ausgabe['OriginalTitle'] = $someArray->OriginalTitle;

        // Plot
        $ausgabe['Plot'] = $someArray->Plot;

        // Image
        $ausgabe['Image'] = $someArray->Image;

        // Release date
        $ausgabe['ReleaseDate'] = $someArray->Release;

        // Gerne
        $ausgabe['Gernes'] = $someArray->Gerne;

        // Director
        $ausgabe['Director'] = $someArray->Director;

        // Cast
        $ausgabe['Cast'] = $someArray->Cast;

        // Image
        $ausgabe['Image'] = $someArray->Image;

        // Path
        //$ausgabe['Path'] = $someArray->Path;

        return $ausgabe;
    }

    function json_encode_tanscode_profil($ordner, $file, $inhalt) {

        $transcodeProfil = [];

        // vcodec
        $transcodeProfil['vcodec'] = $inhalt['-vcodec'];

        // acodec
        $transcodeProfil['acodec'] = $inhalt['-acodec'];

        // vaufleusung
        $transcodeProfil['vaufleusung'] = $inhalt['-vaufleusung'];

        // vaspectratio
        $transcodeProfil['vaspectratio'] = $inhalt['-vaspectratio'];

        // threads
        //$transcodeProfil['threads'] = $inhalt['-threads'];

        // vbittrate
        $transcodeProfil['vbittrate'] = $inhalt['-vbittrate'];

        // vmaxb
        $transcodeProfil['vmaxb'] = $inhalt['-vmaxb'];

        // vminb
        $transcodeProfil['vminb'] = $inhalt['-vminb'];

        // vbuffersize
        $transcodeProfil['vbuffersize'] = $inhalt['-vbuffersize'];

        // abittrate
        $transcodeProfil['abittrate'] = $inhalt['-abittrate'];

        // epgid
        $transcodeProfil['epgid'] = $inhalt['-epgid'];

        // logopath
        $transcodeProfil['logopath'] = $inhalt['-logopath'];

        // overlay
        $transcodeProfil['overlay'] = $inhalt['-overlay'];

        $someArray = json_encode($transcodeProfil, JSON_UNESCAPED_UNICODE);

        //file_put_contents('myfile.json', $someArray);

        $fp = fopen($ordner . '/' . $file . '.json', 'w');
        fwrite($fp, $someArray);
        fclose($fp);

        return $someArray;

    }

    function json_decode_tanscode_profil($ordner, $file) {

        $jsonfile = file_get_contents($ordner . '/' . $file . '.json');

        $ausgabe = [];

        $someArray = json_decode($jsonfile);

        // vcodec
        $ausgabe['vcodec'] = $someArray->vcodec;

        // acodec
        $ausgabe['acodec'] = $someArray->acodec;

        // vaufleusung
        $ausgabe['vaufleusung'] = $someArray->vaufleusung;

        // vaspectratio
        $ausgabe['vaspectratio'] = $someArray->vaspectratio;

        // threads
        //$ausgabe['threads'] = $someArray->threads;

        // vbittrate
        $ausgabe['vbittrate'] = $someArray->vbittrate;

        // vmaxb
        $ausgabe['vmaxb'] = $someArray->vmaxb;

        // vminb
        $ausgabe['vminb'] = $someArray->vminb;

        // vbuffersize
        $ausgabe['vbuffersize'] = $someArray->vbuffersize;

        // abittrate
        $ausgabe['abittrate'] = $someArray->abittrate;

        // epgid
        $ausgabe['epgid'] = $someArray->epgid;

        // logopath
        $ausgabe['logopath'] = $someArray->logopath;

        // overlay
        $ausgabe['overlay'] = $someArray->overlay;



        return $ausgabe;

    }

    function json_encode_tanscode_script($ordner, $file, $inhalt) {

        $transcodeProfilsa = $inhalt;


        $someArray = json_encode($transcodeProfilsa, JSON_UNESCAPED_UNICODE);


        $fp = fopen($ordner . $file . '.json', 'w');
        fwrite($fp, $someArray);
        fclose($fp);

        return $someArray;

    }

    function json_decode_tanscode_script($ordner, $file) {

        $jsonfile = file_get_contents($ordner . '/' . $file . '.json');

        //$ausgabe = [];

        $someArray = json_decode($jsonfile);

        $ausgabe = $someArray;

        return $ausgabe;

    }

 }


?>


