<?php



class TheMoviedb {

    function CheckApiKey($key) {

        $material = [];
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.themoviedb.org/3/authentication/token/new?api_key=$key",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            //CURLOPT_POSTFIELDS => "{}",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $material = $response;
        }

        return $material;
    }

    function FilmSucheImage($film, $sprache) {

        $material = [];

        global $ApiKey;

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.themoviedb.org/3/movie/$film/images?include_image_language=$sprache&language=$sprache&api_key=$ApiKey",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            //CURLOPT_POSTFIELDS => "{}",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $material = $response;
        }

        return $material;
    }


    function FilmSuche($film, $sprache) {

        $material = [];
        global $ApiKey;
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.themoviedb.org/3/search/movie?api_key=$ApiKey&language=$sprache&query=$film&page=1&include_adult=false",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            //CURLOPT_POSTFIELDS => "{}",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $material = $response;
        }

        return $material;
    }

    function FilmSucheID($id, $sprache) {

        $material = [];
        global $ApiKey;
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.themoviedb.org/3/movie/$id?language=$sprache&api_key=$ApiKey",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            //CURLOPT_POSTFIELDS => "{}",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $material = $response;
        }
        return $material;

    }

    function Credits($id) {

        $material = [];
        global $ApiKey;
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.themoviedb.org/3/movie/$id/credits?api_key=$ApiKey",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            //CURLOPT_POSTFIELDS => "{}",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $material = $response;
        }
        return $material;
    }
}

class FilmEigenschaften {

    function json_decode_plot($inhalt) {

        $ausgabe = [];

        $someArray = json_decode($inhalt);

        // ID
        $ausgabe['id'] = $someArray->id;

        // runtime
        $ausgabe['runtime'] = $someArray->runtime;

        // Title
        $ausgabe['Title'] = $someArray->title;

        // vote_average
        $ausgabe['vote_average'] = $someArray->vote_average;

        // Original Title
        $ausgabe['OriginalTitle'] = $someArray->original_title;

        // Plot
        $ausgabe['Plot'] = $someArray->overview;

        // Image
        $ausgabe['Image'] = $someArray->poster_path;

        // Release date
        $ausgabe['ReleaseDate'] = strstr($someArray->release_date, '-', true);

        // Gerne
        $Gerness = [];
        $i = 0;
        while ($i < count($someArray->genres)) {
            $Gerness[] = $someArray->genres[$i]->name;
            $i++;
        }
        $Gernes = implode(' / ', $Gerness);
        $ausgabe['Gernes'] = $Gernes;

        return $ausgabe;

    }

    function json_decode_cast($inhalt, $ausgabe2) {

        $Casttt = [];
        $someArray1 = json_decode($inhalt);

        // Director
        if (!empty($someArray1->crew[0]->name)) {
            $ausgabe2['Director'] = $someArray1->crew[0]->name;
        } else {
            $ausgabe2['Director'] = '';
        }

        // Cast
        $Castt = [];

        $i = 0;
        while ($i < count($someArray1->cast)) {
            $Castt['name'][] = $someArray1->cast[$i]->name;
            $Castt['character'][] = $someArray1->cast[$i]->character;
            $i++;
            if ($i >= 10) {
                break;
            }
        }

        $i = 0;
        while ($i < count($Castt['name'])) {
            $Casttt[] = $Castt['name'][$i] . " (as " .  $Castt['character'][$i] . ")";
            $i++;
        }

        $ausgabe2['Cast'] = implode(', ', $Casttt);

        return $ausgabe2;

    }
}
?>
